/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.item;

import java.util.List;
import javax.annotation.Nullable;
import lykrast.defiledlands.common.entity.projectile.EntityRavagerProjectile;
import lykrast.defiledlands.common.init.ModPotions;
import lykrast.defiledlands.common.item.IPellet;
import lykrast.defiledlands.common.util.LocUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPellet
extends Item
implements IPellet {
    private int damage;

    public ItemPellet(int damage) {
        this.damage = damage;
    }

    @Override
    public EntityRavagerProjectile applyAttributes(EntityRavagerProjectile projectile, ItemStack stack) {
        projectile.setItem(new ItemStack((Item)this));
        projectile.setDamage(this.damage);
        return projectile;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(LocUtils.getTooltips(TextFormatting.GRAY.toString() + I18n.func_135052_a((String)(super.func_77667_c(stack) + ".tooltip"), (Object[])new Object[0])));
    }

    public static class Ravaging
    extends ItemPellet {
        public Ravaging(int damage) {
            super(damage);
        }

        @Override
        public void onHit(EntityLivingBase target, EntityLivingBase source, ItemStack pellet) {
            target.func_70690_d(new PotionEffect(ModPotions.vulnerability, 200));
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_77636_d(ItemStack stack) {
            return true;
        }
    }

    public static class Spiked
    extends ItemPellet {
        public Spiked(int damage) {
            super(damage);
        }

        @Override
        public void onHit(EntityLivingBase target, EntityLivingBase source, ItemStack pellet) {
            int i = 0;
            if (target.func_70644_a(ModPotions.bleeding)) {
                i = target.func_70660_b(ModPotions.bleeding).func_76458_c() + 1;
                i = Math.min(i, 255);
            }
            target.func_70690_d(new PotionEffect(ModPotions.bleeding, 200, i));
        }
    }
}

